<?php
// admin_register.php
include '../config/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT); 
    $role = 'admin';

    // Check if the admin username already exists
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $adminExists = $stmt->rowCount();

    if ($adminExists) {
        $message = "<div class='alert alert-warning text-center'>Admin with this username already exists. Please login.</div>";
    } else {
        $stmt = $pdo->prepare("INSERT INTO users (username, password, role) VALUES (?, ?, ?)");
        if ($stmt->execute([$username, $password, $role])) {
            $message = "<div class='alert alert-success text-center'>Admin registered successfully! Redirecting to login...</div>";
            header("refresh:3;url=login.php"); // Redirect to login page after 3 seconds
            exit(); // Important to stop script execution after redirect
        } else {
            $message = "<div class='alert alert-danger text-center'>Error registering admin.</div>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Registration</title>
    <!-- Bootstrap 5 -->

    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>



    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- Custom Styles -->
    <style>
        body {
            background: linear-gradient(135deg, #17a2b8, #6c757d);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: 'Arial', sans-serif;
        }
        .form-container {
            width: 100%;
            max-width: 450px;
            padding: 40px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            animation: fadeIn 1s ease;
        }
        .drug-icon {
            font-size: 70px;
            color: #17a2b8;
            margin-bottom: 20px;
            animation: bounce 1.2s infinite;
        }
        .form-heading {
            margin-bottom: 30px;
            font-weight: bold;
        }
        .btn-primary {
            background: linear-gradient(135deg, #17a2b8, #6c757d);
            border: none;
            transition: all 0.4s ease;
        }
        .btn-primary:hover {
            background: #138496;
        }
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        @keyframes bounce {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-10px);
            }
        }
    </style>
</head>
<body>

    <div class="form-container text-center">
        <i class="fas fa-pills drug-icon"></i>
        <h2 class="form-heading">Admin Registration</h2>

        <?php if(isset($message)) echo $message; ?>

        <form method="POST" action="">
            <div class="mb-3">
                <label for="username" class="form-label">Username</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-user"></i></span>
                    <input type="text" name="username" id="username" class="form-control" required>
                </div>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Password</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                    <input type="password" name="password" id="password" class="form-control" required>
                </div>
            </div>
            <button type="submit" class="btn btn-primary btn-block w-100">Register</button>
        </form>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
