<?php
session_start();
require_once '../config/db.php';

header('Content-Type: application/json');

// Check admin access
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

try {
    $data = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($data['id'])) {
        throw new Exception('Entry ID is required');
    }

    $stmt = $pdo->prepare("UPDATE accounting_templates SET is_active = 0 WHERE id = ?");
    $success = $stmt->execute([$data['id']]);

    echo json_encode(['success' => $success]);

} catch (Exception $e) {
    error_log("Delete Entry Error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}