<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] != 'admin') {
    header("Location: login.php");
    exit();
}

// Include database connection
include '../config/db.php'; // Adjust the path as necessary

// Check if the user ID is set in the URL
if (isset($_GET['id'])) {
    $user_id = $_GET['id'];

    // Prepare the delete statement
    try {
        $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        
        // Redirect back to manage users page after deletion
        header("Location: manage_users.php");
        exit();
    } catch (PDOException $e) {
        die("Delete failed: " . $e->getMessage());
    }
} else {
    header("Location: manage_users.php");
    exit();
}
?>
