<?php
require_once '../config/db.php';
header('Content-Type: application/json');

try {
    if (!isset($_GET['barcode'])) {
        throw new Exception('Barcode parameter is required');
    }

    $barcode = trim($_GET['barcode']);
    
    // Query to get product by barcode
    $stmt = $pdo->prepare("SELECT * FROM drugs WHERE barcode = ?");
    $stmt->execute([$barcode]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($product) {
        echo json_encode([
            'success' => true,
            'product' => $product
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Product not found'
        ]);
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}