<?php
// Include your database connection (adjust the path to your actual db file)
include('../config/db.php');

// Fetch current settings from the database
$stmt = $pdo->prepare("SELECT * FROM settings WHERE id = 1");  // Assuming you're storing only one row of settings
$stmt->execute();
$settings = $stmt->fetch(); // Changed from $setting to $settings

// If settings are not found, you can set default values
if (!$settings) {
    $settings = [
        'pharmacy_name' => '',
        'pharmacy_address' => '',
        'pharmacy_phone' => '',
        'pharmacy_email' => '',
        'pharmacy_logo' => '',
        'pharmacy_description' => '',
        'notifications_enabled' => 1 // Add default value for notifications
    ];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Store Management</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    
    <style>
        body {
            background-color: #f5f6fa;
            font-family: 'Mulish', sans-serif;
            overflow-x: hidden;
        }

        .content {
            margin-left: 240px;
            padding: 20px;
            transition: margin-left 0.3s ease;
        }

        .top-bar {
            background-color: #ffffff;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .settings-card {
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }

        .form-label {
            font-weight: 500;
            color: #2c3e50;
        }

        .gap-2 {
            gap: 0.5rem;
        }

        @media (max-width: 768px) {
            .content {
                margin-left: 0;
                padding: 10px;
            }
            
            .mobile-toggle {
                display: block;
            }

            .d-flex.gap-2 {
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .d-flex.gap-2 .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/side_bar.php'; ?>

    <!-- Mobile Toggle Button -->
    <button class="mobile-toggle d-md-none" onclick="toggleSidebar()">
        <i class="fas fa-bars"></i>
    </button>

    <div class="content">
        <!-- Top Bar -->
        <div class="top-bar">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Store Settings</h4>
                <div class="d-flex gap-2">
                    <a href="add_payment_method.php" class="btn btn-primary">
                        <i class="fas fa-credit-card"></i> Payment Methods
                    </a>
                    <a href="admin_dashboard.php" class="btn btn-outline-primary">
                        <i class="fas fa-arrow-left"></i> Back to Dashboard
                    </a>
                </div>
            </div>
        </div>

        <!-- Settings Form -->
        <div class="settings-card">
            <form action="update_settings_process.php" method="POST" enctype="multipart/form-data">
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="pharmacy_name" class="form-label">Store Name</label>
                            <input type="text" class="form-control" id="pharmacy_name" 
                                   name="pharmacy_name" value="<?= htmlspecialchars($settings['pharmacy_name']) ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="pharmacy_phone" class="form-label">Phone Number</label>
                            <input type="text" class="form-control" id="pharmacy_phone" 
                                   name="pharmacy_phone" value="<?= htmlspecialchars($settings['pharmacy_phone']) ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="pharmacy_email" class="form-label">Email Address</label>
                            <input type="email" class="form-control" id="pharmacy_email" 
                                   name="pharmacy_email" value="<?= htmlspecialchars($settings['pharmacy_email']) ?>" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="pharmacy_logo" class="form-label">Store Logo</label>
                            <input type="file" class="form-control" id="pharmacy_logo" name="pharmacy_logo">
                            <?php if ($settings['pharmacy_logo']): ?>
                                <div class="mt-2">
                                    <img src="uploads/<?= htmlspecialchars($settings['pharmacy_logo']) ?>" 
                                         alt="Logo" class="img-thumbnail" style="height: 50px;">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="mb-3">
                            <label for="pharmacy_address" class="form-label">Store Address</label>
                            <textarea class="form-control" id="pharmacy_address" name="pharmacy_address" 
                                    rows="2" required><?= htmlspecialchars($settings['pharmacy_address']) ?></textarea>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="mb-3">
                            <label for="pharmacy_description" class="form-label">Store Description</label>
                            <textarea class="form-control" id="pharmacy_description" name="pharmacy_description" 
                                    rows="3"><?= htmlspecialchars($settings['pharmacy_description']) ?></textarea>
                        </div>
                    </div>
                </div>
                
                <div class="text-end mt-4">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Save Changes
                    </button>
                </div>
            </form>
        </div>

        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-bell me-2"></i>Notification Settings</h5>
            </div>
            <div class="card-body">
                <form action="update_settings.php" method="POST">
                    <div class="form-check form-switch">
                        <input type="checkbox" 
                               class="form-check-input" 
                               id="notificationsEnabled" 
                               name="notifications_enabled" 
                               <?php echo $settings['notifications_enabled'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="notificationsEnabled">
                            Enable Notifications
                        </label>
                    </div>
                    <small class="text-muted d-block mb-3">
                        When enabled, you'll receive notifications for:
                        <ul class="mt-2">
                            <li>Low stock alerts</li>
                            <li>Expiring products</li>
                        </ul>
                    </small>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Save Settings
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="..\libs\jquery\jquery-3.7.1.min.js"></script>
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <script>
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('active');
            document.querySelector('.content').classList.toggle('sidebar-active');
        }
    </script>
</body>
</html>
