<?php
// Check if the user is a staff member and restrict other actions
session_start();
if ($_SESSION['role'] !== 'staff') {
    header('Location: unauthorized.php');  // Redirect to unauthorized page if not a staff
    exit();
}


// Calculate the total owings for the user
$owingStmt = $pdo->prepare("SELECT SUM(amount) AS total_owing FROM owings WHERE created_by = :username AND status = 'owing'");
$owingStmt->execute(['username' => $username]);
$owingRow = $owingStmt->fetch(PDO::FETCH_ASSOC);
$totalOwing = $owingRow['total_owing'] ?? 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Owing Management</title>
    <link rel="stylesheet" href="..\libs\bootsrtap\css\bootstrap.min.css">
    <link rel="stylesheet" href="..\libs\fontawesome\css\all.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
    <style>
        body {
            background-color: #f5f7fa;
            font-size: 14px;
        }
        .container {
            max-width: 900px;
            margin-top: 20px;
        }
        h2 {
            color: #343a40;
            font-weight: bold;
            text-align: center;
            margin-bottom: 30px;
            font-size: 1.5rem;
        }
        .table-container {
            background-color: #ffffff;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
        }
        .btn-toggle {
            border: none;
            color: blue;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: bold;
            transition: background-color 0.3s;
            margin: 5px;
        }
        .btn-toggle.active {
            background-color: #0056b3;
            color: #fff;
        }
        .table th, .table td {
            vertical-align: middle;
            font-size: 0.875rem;
        }
        .badge-owing {
            background-color: #dc3545;
        }
        .badge-paid {
            background-color: #6c757d;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Owing Management System</h2>
    
    <!-- Add Owing Button for Staff -->
     
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addOwingModal">Add New Owing</button>

    <!-- Owing Records Table -->
    <div class="table-container table-responsive">
        <h5 class="text-center mb-4">Owing Records</h5>
        <table class="table table-striped table-hover">
            <thead class="table-dark">
                <tr>
                    <th>Name</th>
                    <th>Phone Number</th>
                    <th>Amount</th>
                    <th>Owing Type</th>
                    <th>Description</th>
                    <th>Amount Paid</th> 
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    require '../config/db.php';
                    $sql = "SELECT * FROM owings ORDER BY id DESC"; // Retrieve all owing records
                    $owings = $pdo->query($sql)->fetchAll();
                    foreach ($owings as $owing):
                ?>
                    <tr data-owing-type="<?= $owing['owing_type'] ?>" data-amount="<?= $owing['amount'] ?>" data-status="<?= $owing['status'] ?>">
                        <td><?= htmlspecialchars($owing['person_name']) ?></td>
                        <td><?= htmlspecialchars($owing['phone_number']) ?></td>
                        <td><?= number_format($owing['amount'], 2) ?></td>
                        <td><?= $owing['owing_type'] === 'owed_to' ? 'Owed to Me' : 'I Owe' ?></td>
                        <td><?= htmlspecialchars($owing['description']) ?></td>
                        <td><?= number_format($owing['amount_paid'], 2) ?></td>
                        <td>
                            <span class="badge <?= $owing['status'] === 'Owing' ? 'badge-owing' : 'badge-paid' ?>">
                                <?= htmlspecialchars($owing['status']) ?>
                            </span>
                        </td>
                        <td>
                            <a href="view_payments.php?owing_id=<?= $owing['id'] ?>" class="btn btn-info btn-sm">View Payments</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Add Owing Modal -->
<div class="modal fade" id="addOwingModal" tabindex="-1" aria-labelledby="addOwingModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="add_owing_action.php" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title" id="addOwingModalLabel">Add Owing</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="personName" class="form-label">Person's Name</label>
                        <input type="text" class="form-control" id="personName" name="person_name" required>
                    </div>
                    <div class="mb-3">
                        <label for="amount" class="form-label">Amount</label>
                        <input type="number" class="form-control" id="amount" name="amount" required>
                    </div>
                    <div class="mb-3">
                        <label for="owingType" class="form-label">Owing Type</label>
                        <select class="form-select" id="owingType" name="owing_type" required>
                            <option value="owed_to">Owed to Me</option>
                            <option value="i_owe">I Owe</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Add Owing</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>
            </form>
        </div>
    </div>
</div>

</body>
</html>
