<?php
// Include the database connection
require_once '../config/db.php';
session_start();

// Check if the admin is logged in
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit();
}

// Fetch all customers
$customers_sql = "SELECT id, full_name FROM customers ORDER BY full_name ASC";
$customers_stmt = $pdo->prepare($customers_sql);
$customers_stmt->execute();
$customers = $customers_stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch sales for a selected customer
$sales = [];
if (isset($_GET['customer_id'])) {
    $customer_id = $_GET['customer_id'];

    $sales_sql = "SELECT drug_name, quantity, total, sale_date FROM sales WHERE customer_id = ? ORDER BY sale_date DESC";
    $sales_stmt = $pdo->prepare($sales_sql);
    $sales_stmt->execute([$customer_id]);
    $sales = $sales_stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Customer Sales</title>
    <link rel="stylesheet" href="..\libs\bootstrap\css\bootstrap.min.css">
    <script src="..\libs\bootsrtap\js\bootstrap.bundle.min.js"></script>
</head>
<body>
<div class="container mt-5">
    <h2 class="text-center mb-4">View Sales by Customer</h2>
    <form method="get" class="mb-4">
        <div class="row">
            <div class="col-md-8">
                <select name="customer_id" class="form-control" required>
                    <option value="" disabled selected>Select a Customer</option>
                    <?php foreach ($customers as $customer): ?>
                        <option value="<?= htmlspecialchars($customer['id']) ?>" 
                            <?= (isset($_GET['customer_id']) && $_GET['customer_id'] == $customer['id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($customer['full_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-primary btn-block">View Sales</button>
            </div>
        </div>
    </form>

    <?php if (isset($_GET['customer_id']) && count($sales) > 0): ?>
        <h4 class="mb-3">Sales for <?= htmlspecialchars($customers[array_search($_GET['customer_id'], array_column($customers, 'id'))]['full_name']) ?></h4>
        <table class="table table-bordered table-striped">
            <thead>
            <tr>
                <th>Item Name</th>
                <th>Quantity</th>
                <th>Total</th>
                <th>Sale Date</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($sales as $sale): ?>
                <tr>
                    <td><?= htmlspecialchars($sale['drug_name']) ?></td>
                    <td><?= htmlspecialchars($sale['quantity']) ?></td>
                    
                    <td>₦<?= number_format($sale['total'], 2) ?></td>
                    <td><?= htmlspecialchars($sale['sale_date']) ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php elseif (isset($_GET['customer_id'])): ?>
        <div class="alert alert-info">No sales found for this customer.</div>
    <?php endif; ?>
</div>
</body>
</html>
